using WPFGallery.Navigation;
using WPFGallery.Views;
using WPFGallery.Models;

namespace WPFGallery.ViewModels
{
    public partial class BasicInputPageViewModel : ObservableObject
    {
        [ObservableProperty]
        private string _pageTitle = "Basic Input";

        [ObservableProperty]
        private string _pageDescription = "Controls for getting user input";

        [ObservableProperty]
        private ICollection<ControlInfoDataItem> _navigationCards = ControlsInfoDataSource.Instance.GetControlsInfo("Basic Input");

        private readonly INavigationService _navigationService;

        public BasicInputPageViewModel(INavigationService navigationService)
        {
            _navigationService = navigationService;
        }

        [RelayCommand]
        public void Navigate(object pageType){
            if (pageType is Type page)
            {
                _navigationService.NavigateTo(page);
            }
        }

        
    }
}
